import streamlit as st
from utils import load_pdf_chunks, build_faiss_index, get_answer
import os
from dotenv import load_dotenv

load_dotenv()
st.set_page_config(page_title="PDF Q&A Bot", layout="centered")
st.title("📄 Ask Questions to Your PDF")

uploaded_file = st.file_uploader("Upload a PDF", type="pdf")

if uploaded_file:
    with open("temp.pdf", "wb") as f:
        f.write(uploaded_file.read())
    st.success("PDF uploaded successfully!")

    with st.spinner("Reading and indexing the document..."):
        chunks = load_pdf_chunks("temp.pdf")
        faiss_index = build_faiss_index(chunks)

    st.success("Document is ready for questions!")

    query = st.text_input("Ask a question:")
    if query:
        with st.spinner("Thinking..."):
            answer = get_answer(faiss_index, query)
        st.markdown(f"**Answer:** {answer}")

