import argparse
import os
import json
import csv

def parse_file(path, file_type):
    if not os.path.exists(path):
        print("File not exist.")
        return

    try:
        if file_type == "text":
            with open(path, "r") as f:
                print(f.read())

        elif file_type == "lines":
            with open(path, "r") as f:
                for i, line in enumerate(f, 1):
                    print(f"{i}: {line.strip()}")

        elif file_type == "csv":
            with open(path, newline='') as f:
                reader = csv.reader(f)
                for row in reader:
                    print(row)

        elif file_type == "json":
            with open(path, "r") as f:
                data = json.load(f)
                print(json.dumps(data, indent=2))

        else:
            print("Unsupported file type.")

    except Exception as e:
        print("Error:", e)

def main():
    parser = argparse.ArgumentParser(description="File Parser CLI")
    parser.add_argument("filepath", help="Path to file")
    parser.add_argument("--type", default="text", choices=["text", "lines", "csv", "json"])
    args = parser.parse_args()
    parse_file(args.filepath, args.type)

if __name__ == "__main__":
    main()

