import os
from dotenv import load_dotenv
import openai
import anthropic

# Load API keys
load_dotenv()
openai.api_key = os.getenv("OPENAI_API_KEY")
claude_client = anthropic.Anthropic(api_key=os.getenv("ANTHROPIC_API_KEY"))

# Step 1: Claude does the topic research
def research_with_claude(topic: str) -> str:
    print(f"🔍 Researching topic: {topic}")
    response = claude_client.messages.create(
        model="claude-3-sonnet-20240229",
        max_tokens=1024,
        temperature=0.5,
        messages=[
            {"role": "user", "content": f"Conduct detailed research on: {topic}. Include facts, trends, and examples."}
        ]
    )
    return response.content[0].text

# Step 2: OpenAI summarizes the research
def summarize_with_openai(content: str) -> str:
    print("📝 Generating summary...")
    response = openai.ChatCompletion.create(
        model="gpt-4",
        messages=[
            {"role": "system", "content": "You are a summarizer assistant."},
            {"role": "user", "content": f"Summarize the following content:\n\n{content}"}
        ],
        temperature=0.7,
        max_tokens=300
    )
    return response["choices"][0]["message"]["content"]

# Main function
if __name__ == "__main__":
    topic = input("Enter a topic for research: ")
    research_text = research_with_claude(topic)
    print("\n📚 Research Output:\n", research_text)

    summary = summarize_with_openai(research_text)
    print("\n📌 Summary:\n", summary)
