class Student:
    def __init__(self, roll_no, name, age):
        self.roll_no = roll_no
        self.name = name
        self.age = age

    def display(self):
        print(f"Roll No: {self.roll_no}, Name: {self.name}, Age: {self.age}")

students = []

def add_student():
    roll_no = input("Enter roll number: ")
    name = input("Enter name: ")
    age = input("Enter age: ")
    student = Student(roll_no, name, age)
    students.append(student)
    print("Student added successfully!")

def view_students():
    if not students:
        print("No students to display.")
    else:
        print("Student List:")
        for s in students:
            s.display()

def search_student():
    roll_no = input("Enter roll number to search: ")
    found = False
    for s in students:
        if s.roll_no == roll_no:
            print("Student found:")
            s.display()
            found = True
            break
    if not found:
        print("Student not found.")

def delete_student():
    roll_no = input("Enter roll number to delete: ")
    for s in students:
        if s.roll_no == roll_no:
            students.remove(s)
            print("Student deleted.")
            return
    print("Student not found.")

def main():
    while True:
        print("\n=== Student Management System ===")
        print("1. Add Student")
        print("2. View All Students")
        print("3. Search Student")
        print("4. Delete Student")
        print("5. Exit")

        choice = input("Enter your choice (1-5): ")

        if choice == "1":
            add_student()
        elif choice == "2":
            view_students()
        elif choice == "3":
            search_student()
        elif choice == "4":
            delete_student()
        elif choice == "5":
            break
        else:
            print("Invalid choice.try again")

main()

