from langgraph.graph import StateGraph, END

def symptom_state():
    return {"symptoms": None, "api_result": None}

# Node 1: Get user symptoms
def get_symptoms(state):
    symptoms = input("What symptoms are you experiencing? ")
    return {"symptoms": symptoms}

# Node 2: Validate symptoms
def validate_symptoms(state):
    symptoms = state["symptoms"]
    if len(symptoms.strip().split()) < 3:
        print("Please provide more details.")
        return "get_symptoms"
    return "call_api"

# Node 3: Simulate API call
def call_medical_api(state):
    symptoms = state["symptoms"]
    result = f"Simulated advice for symptoms: {symptoms}"
    return {"api_result": result}

# Node 4: Return advice
def return_advice(state):
    print("\n=== Diagnosis Summary ===")
    print(f"Symptoms: {state['symptoms']}")
    print(f"Advice: {state['api_result']}")
    return END

# Build graph
builder = StateGraph(symptom_state)
builder.add_node("get_symptoms", get_symptoms)
builder.add_node("validate", validate_symptoms)
builder.add_node("call_api", call_medical_api)
builder.add_node("return_advice", return_advice)

builder.set_entry_point("get_symptoms")
builder.add_edge("get_symptoms", "validate")
builder.add_conditional_edges("validate", validate_symptoms)
builder.add_edge("call_api", "return_advice")

app = builder.compile()
app.invoke({})

