import sys
class FileParser:
    def __init__(self, filename):
        self.filename = filename
        self.ccount = 0
        self.wcount = 0
        self.lcount = 0
        self.count()  

    def count(self):
        try:
            with open(self.filename, "r") as f:
                for line in f:
                    self.lcount += 1
                    self.ccount += len(line)
                    self.wcount += len(line.split())
        except Exception as e:
            print(f"Error reading file: {e}")

    def report(self):
        print(f"The file has {self.ccount} characters, {self.wcount} words and {self.lcount} lines")


if __name__== "__main__":
    if len(sys.argv) !=2:
        print("Usage: py parser.py <filename>")
    else:
        obj1 = FileParser(sys.argv[1])
        obj1.report()