import streamlit as st
import yfinance as yf
from datetime import date
from transformers import pipeline


@st.cache_resource
def get_summarizer():
    return pipeline("summarization", model="facebook/bart-large-cnn")

summarizer = get_summarizer()



st.set_page_config(page_title="Stock Dashboard & Summarizer", layout="wide")
st.title(" Stock Price Dashboard &  Text Summarizer")

tab1, tab2 = st.tabs([" Stock Visualization", " Stock Text Summarization"])


with tab1:
    st.header("Stock Price Dashboard")
    ticker = st.text_input("Enter Stock Ticker Symbol (e.g., AAPL, MSFT)", "AAPL")

    col1, col2 = st.columns(2)
    with col1:
        start_date = st.date_input("Start Date", date(2022, 1, 1))
    with col2:
        end_date = st.date_input("End Date", date.today())

    if st.button("Fetch Stock Data"):
        data = yf.download(ticker, start=start_date, end=end_date)
        if data.empty:
            st.error("No data found. Please check the ticker symbol.")
        else:
            st.subheader(f"Stock Data for {ticker.upper()}")
            st.line_chart(data['Close'], use_container_width=True)
            st.area_chart(data['Volume'], use_container_width=True)

with tab2:
    st.header("Summarize Stock-Related Text")
    input_text = st.text_area("Paste a stock news article or report below:", height=300)

    if st.button("Summarize"):
        if len(input_text.strip()) < 100:
            st.warning("Please provide a longer text (at least 100 characters).")
        else:
            with st.spinner("Summarizing..."):
                summary = summarizer(input_text, max_length=130, min_length=30, do_sample=False)
                st.success("Summary Generated:")
                st.write(summary[0]['summary_text'])
