class Student:
    def __init__(self, student_id, name, age, grade):
        self.student_id = student_id    
        self.name = name
        self.age = age
        self.grade = grade

    def __str__(self):
        return f"ID:{self.student_id}, Name:{self.name}, Age:{self.age}, Grade:{self.grade}"


class smanager:
    def __init__(self):
        self.students = []

    def add_student(self, student):
        self.students.append(student)

    def view_students(self):
        for student in self.students:
            print(student)

    def find_student(self, student_id):
        for student in self.students:
            if student.student_id == student_id:
                return student
        return None

    def update_student(self, student_id, name=None, age=None, grade=None):
        student = self.find_student(student_id)
        if student:
            if name: student.name = name
            if age: student.age = age
            if grade: student.grade = grade
            print("Student updated")
        else:
            print("Student not found")

    def delete_student(self, student_id):
        student = self.find_student(student_id)
        if student:
            self.students.remove(student)
            print("Student deleted successfully")
        else:
            print("Student not found")


def main():
    manager = smanager()

    while True:
        print("\n--- Student Management System ---")
        print("1. Add Student")
        print("2. View All Students")
        print("3. Search Student by ID")
        print("4. Update Student")
        print("5. Delete Student")
        print("6. Exit")

        choice = input("Enter choice: ")

        if choice == "1":
            sid = input("ID: ")
            name = input("Name: ")
            age = int(input("Age: "))
            grade = input("Grade: ")
            student = Student(sid, name, age, grade)
            manager.add_student(student)
            print("Student added successfully!")

        elif choice == "2":
            manager.view_students()

        elif choice == "3":
            sid = input("Enter Student ID to search: ")
            student = manager.find_student(sid)
            print(student if student else "Student not found.")

        elif choice == "4":
            sid = input("ID to update: ")
            name = input("New Name (or leave blank): ")
            age = input("New Age (or leave blank): ")
            grade = input("New Grade (or leave blank): ")

            manager.update_student(
                sid,
                name=name if name else None,
                age=int(age) if age else None,
                grade=grade if grade else None
            )

        elif choice == "5":
            sid = input("Enter ID to delete: ")
            manager.delete_student(sid)

        elif choice == "6":
            print("Exiting!")
            break

        else:
            print("Invalid choice. Try again.")


if __name__ == "__main__":
    main()