from fastapi import FastAPI
from .db import engine, sessionLocal,get_db,Base
from .routers import tasks, users, auth
from .auth import  auth_router
from . import models

app = FastAPI(title="Task manager API")

Base.metadata.create_all(bind=engine)

app.include_router(auth_router.router,prefix='/auth', tags=['Authentication'])
app.include_router(users.router,prefix='/users',tags=["Users"])
app.include_router(tasks.router,prefix='/tasks', tags=['Tasks'])