import sys
import os

def parse_file(filename):
    if not os.path.isfile(filename):
        print("File not found!")
        return

    with open(filename, 'r') as file:
        content = file.read()

    lines = content.split('\n')
    words = content.split()
    characters = len(content)

    print(f"\n File Analysis: {filename}")
    print(f"Lines     : {len(lines)}")
    print(f"Words     : {len(words)}")
    print(f"Characters: {characters}")

if __name__ == "__main__":
    if len(sys.argv) < 2:
        print("Usage: python file_parser.py <filename>")
    else:
        parse_file(sys.argv[1])