from openpyxl import Workbook, load_workbook
import os
from tabulate import tabulate

EXCEL_FILE = "students.xlsx"

class Student:
    def __init__(self, student_id, name, grade):
        self.student_id = student_id
        self.name = name
        self.grade = grade

    def display(self):
        return f"{self.student_id} - {self.name} (Grade: {self.grade})"

class StudentManager:
    def __init__(self):
        # if not os.path.exists(EXCEL_FILE):
        #     wb = Workbook()
        #     ws = wb.active
        #     ws.title = "Students"
        #     ws.append(["Student ID", "Name", "Grade"])
        #     wb.save(EXCEL_FILE)

        self.students = []

    def add_student(self, student_id, name, grade):
        # wb = load_workbook(EXCEL_FILE)
        # ws = wb["Students"]
        # ws.append([student_id, name, grade])
        # wb.save(EXCEL_FILE)
        # print("Student added to Excel.")

        self.students.append(Student(student_id, name, grade))
        print("✅ Student added.")

    def view_students(self):
        wb = load_workbook(EXCEL_FILE)
        ws = wb["Students"]
        rows = list(ws.iter_rows(values_only=True))[1:]  # skip header
        if not rows:
            print("No students to display.")
        else:
            table = [[row[0], row[1], row[2]] for row in rows]  # Use rows directly
            print(tabulate(table, headers=["Student ID", "Name", "Grade"], tablefmt="grid"))

    def delete_student(self, student_id):
        # wb = load_workbook(EXCEL_FILE)
        # ws = wb["Students"]
        # rows = list(ws.iter_rows(values_only=True))
        # new_rows = [rows[0]]  # keep header
        # found = False
        # for row in rows[1:]:
        #     if str(row[0]) != student_id:
        #         new_rows.append(row)
        #     else:
        #         found = True

        # if found:
        #     ws.delete_rows(2, ws.max_row)  # clear all data
        #     for row in new_rows[1:]:
        #         ws.append(row)
        #     wb.save(EXCEL_FILE)
        #     print("Student removed from Excel.")
        # else:
        #     print("Student not found.")

        found = False
        self.students = [s for s in self.students if s.student_id != student_id]
        if found:
            print("Student removed.")
        else:
            print("Student not found.")

    def update_student(self, student_id, new_name, new_grade):
        # wb = load_workbook(EXCEL_FILE)
        # ws = wb["Students"]
        # updated = False
        # for row in ws.iter_rows(min_row=2):
        #     if str(row[0].value) == student_id:
        #         row[1].value = new_name
        #         row[2].value = new_grade
        #         updated = True
        #         break

        # if updated:
        #     wb.save(EXCEL_FILE)
        #     print("Student updated in Excel.")
        # else:
        #     print("Student not found.")

        for student in self.students:
            if student.student_id == student_id:
                student.name = new_name
                student.grade = new_grade
                print("✅ Student updated.")
                return
        print("Student not found.")

def main():
    manager = StudentManager()

    while True:
        # print("\n🎓 Student Management System with Excel")
        print("\n1. Add Student")
        print("2. View Students")
        print("3. Delete Student")
        print("4. Update Student")
        print("5. Exit")

        choice = input("Enter your choice: ")

        if choice == '1':
            sid = input("Enter student ID: ")
            name = input("Enter name: ")
            grade = input("Enter grade: ")
            manager.add_student(sid, name, grade)
        elif choice == '2':
            manager.view_students()
        elif choice == '3':
            sid = input("Enter student ID to delete: ")
            manager.delete_student(sid)
        elif choice == '4':
            sid = input("Enter student ID to update: ")
            name = input("Enter new name: ")
            grade = input("Enter new grade: ")
            manager.update_student(sid, name, grade)
        elif choice == '5':
            print("Exiting...")
            break
        else:
            print("Invalid choice!")

if __name__ == "__main__":
    main()