from pydantic import BaseModel
from typing import List, Optional

class TodoBase(BaseModel):
    title: str
    completed: Optional[bool] = False

class TodoCreate(TodoBase):
    pass

class Todo(TodoBase):
    id: int
    owner_id: int

    class Config:
        from_attributes = True

class UserBase(BaseModel):
    username: str

class UserCreate(UserBase):
    password: str

class User(UserBase):
    id: int

    class Config:
        from_attributes = True

class Token(BaseModel):
    access_token: str
    token_type: str

class TodoBase(BaseModel):
    title: str
    description: str


class LoginRequest(BaseModel):
    username: str
    password: str