from fastapi import APIRouter, Depends, HTTPException
from models import tasks
from schemas import TaskCreate
from database import database
from websocket_manager import notify_all

router = APIRouter()

@router.post("/tasks/")
async def create_task(task: TaskCreate, user_id: int = 1):  # demo: hardcoded user
    query = tasks.insert().values(title=task.title, user_id=user_id)
    task_id = await database.execute(query)
    await notify_all({"event": "new_task", "title": task.title})
    return {"id": task_id, "title": task.title}