from fastapi import WebSocket
from typing import List

clients: List[WebSocket] = []

async def connect_client(websocket: WebSocket):
    await websocket.accept()
    clients.append(websocket)

async def disconnect_client(websocket: WebSocket):
    clients.remove(websocket)

async def notify_all(message: dict):
    for client in clients:
        await client.send_json(message)