import streamlit as st
import yfinance as yf
from datetime import date
from transformers import pipeline

st.set_page_config(page_title="Stock Dashboard", layout="wide")
st.title("Stock Price Dashboard + Summarizer")

st.sidebar.header("Stock Price Inputs")
ticker = st.sidebar.text_input("Enter Stock Ticker (e.g., AAPL)", value="AAPL")
start_date = st.sidebar.date_input("Start Date", date(2023, 1, 1))
end_date = st.sidebar.date_input("End Date", date.today())

if st.sidebar.button("Show Stock Chart"):
    with st.spinner("Fetching stock data..."):
        try:
            data = yf.download(ticker, start=start_date, end=end_date)
            st.subheader(f"{ticker} Closing Price from {start_date} to {end_date}")
            st.line_chart(data['Close'])
        except Exception as e:
            st.error(f"Failed to fetch stock data: {e}")

st.sidebar.header("Text Summarizer")
text_input = st.sidebar.text_area("Paste stock-related news or article here:")
summarize_button = st.sidebar.button("Summarize Text")

if summarize_button:
    if not text_input.strip():
        st.warning("Please enter some text to summarize.")
    else:
        with st.spinner("Summarizing..."):
            summarizer = pipeline("summarization")
            summary = summarizer(text_input, max_length=120, min_length=30, do_sample=False)
            st.subheader("📝 Summary:")
            st.success(summary[0]['summary_text'])



