import os
from dotenv import load_dotenv

def load_env(env):
    env_path = os.path.join(os.path.dirname(__file__), 'env_files', env, '.env')
    if os.path.exists(env_path):
        load_dotenv(env_path)
        print(f"Loaded {env} environment configuration")
    else:
        raise FileNotFoundError(f".env file for {env} not found.")

# Load environment (default to 'dev' if not provided)
current_env = os.getenv('ENV', 'dev')
load_env(current_env)

class Config:
    SQLALCHEMY_DATABASE_URI = os.getenv('DATABASE_URL')
    SQLALCHEMY_TRACK_MODIFICATIONS = False
    # Microsoft Azure AD Configurations
    CLIENT_ID = os.getenv('CLIENT_ID')
    CLIENT_SECRET = os.getenv('CLIENT_SECRET')
    TENANT_ID = os.getenv('TENANT_ID')
    REDIRECT_URI = os.getenv('REDIRECT_URI')
    POST_LOGOUT_REDIRECT_URI = os.getenv('POST_LOGOUT_REDIRECT_URI')


