from fastapi import status
from fastapi.responses import JSONResponse
from typing import Any
from fastapi.encoders import jsonable_encoder


class DotNotationDict:
    def __init__(self, dictionary):
        self._data = dictionary
    
    def __getattr__(self, name):
        if name in self._data:
            return self._data[name]
        raise AttributeError(f"'{type(self).__name__}' object has no attribute '{name}'")


class GlobalConstants:
    
    api_response_messages = DotNotationDict({
        "success": "successfully",
        "accepted": "Accepted",
        "invalid_request_data": "Invalid request data",
        "unauthorized": "Unauthorized access",
        "forbidden": "Forbidden access",
        "not_found": "Resource not found",
        "method_not_allowed": "Method not allowed for the requested resource",
        "internal_server_error": "Internal server error occurred",
        "missing_required_parameters": "Missing required parameters",
        "error_in": "Error in",
        "db_error" : "An error occurred while accessing the database.",
    })

    # api_request_messages = DotNotationDict({
    # "page_no": 1,
    # "page_size": 10,
    # "filter_data": "Filter data for the request",
    # "page_no_description": "Page number, starting from 1",
    # "page_size_description": "Number of records per page",
    # })

    

    """
    Custom function to generate a standardized JSON response.

    :param message: Message string for the response.
    :param result: The result data to include in the response.
    :return: A FastAPI JSONResponse object.
    """
    @staticmethod
    def return_api_response(message: str, result: Any, status_code: int = status.HTTP_200_OK) -> JSONResponse:
        
        if result:
            result = jsonable_encoder(result)
            
        return JSONResponse(
            status_code=status_code,
            content={
                "message": message,
                "result": result
            }
        )

