from sqlalchemy import Column, Integer, String, DateTime
from app.database import Database
from datetime import datetime, timezone
from pydantic import BaseModel, Field
from typing import Optional

class SimpleModel(Database.Base):
    __tablename__ = "simple_model"

    id = Column(Integer, primary_key=True, autoincrement=True, index=True)
    name = Column(String, nullable=False)
    created_at = Column(DateTime, default=datetime.now(timezone.utc))
    updated_at = Column(DateTime, default=datetime.now(timezone.utc), onupdate=datetime.now(timezone.utc))
    created_by = Column(String, nullable=True)
    updated_by = Column(String, nullable=True)

class SimpleModelCreateSchema(BaseModel):
    name: str = Field(..., example="Test Name")
    created_by: Optional[str] = Field(None, example="admin")

    class Config:
        orm_mode = True

class SimpleModelUpdateSchema(BaseModel):
    simple_model_id: int = Field(..., example=1)
    name: Optional[str] = Field(None, example="Updated Name")
    updated_by: Optional[str] = Field(None, example="admin")

    class Config:
        orm_mode = True

class SimpleModelResponseSchema(BaseModel):
    id: int = Field(..., example=1)
    name: str = Field(..., example="Test Name")
    created_at: Optional[datetime] = Field(None, example="2021-08-01T00:00:00Z")
    updated_at: Optional[datetime] = Field(None, example="2021-08-02T00:00:00Z")
    created_by: Optional[str] = Field(None, example="admin")
    updated_by: Optional[str] = Field(None, example="admin")

    class Config:
        orm_mode = True
        

class RefreshTokenSchema(BaseModel):
    refresh_token: str = Field(..., example="1.AXEAQUoIbQsqQUGl-h6wgPZTJ7o5w2NshyRHuBP3y8d-fjsvAbNxAA.AgABAwEAAABVrSpeuWamRam2jAF1XRQEAwDs_")
    
    class Config:
        orm_mode = True