from sqlalchemy import Column, Integer, String, Boolean, DateTime
from sqlalchemy.dialects.postgresql import UUID
from app.database import Database
from datetime import datetime, timezone
from typing import Optional
from pydantic import BaseModel, Field
from uuid import UUID as UUIDType
import uuid

class ToDo(Database.Base):
    __tablename__ = "todos"

    id = Column(UUID(as_uuid=True), primary_key=True, default=lambda: uuid.uuid4(), index=True)
    title = Column(String, nullable=False)
    description = Column(String, nullable=True)
    is_completed = Column(Boolean, default=False)

    created_at = Column(DateTime, default=lambda: datetime.now(timezone.utc))
    updated_at = Column(DateTime, default=lambda: datetime.now(timezone.utc), onupdate=lambda: datetime.now(timezone.utc))
    
    created_by = Column(UUID(as_uuid=True), nullable=True)
    updated_by = Column(UUID(as_uuid=True), nullable=True)


class ToDoCreateSchema(BaseModel):
    title: str = Field(..., example="Buy groceries")
    description: Optional[str] = Field(None, example="Milk, eggs, bread")
    created_by: Optional[UUIDType] = Field(None, example="123e4567-e89b-12d3-a456-426614174000")

    class Config:
        orm_mode = True


class ToDoUpdateSchema(BaseModel):
    todo_id: UUIDType = Field(..., example="123e4567-e89b-12d3-a456-426614174000")
    title: Optional[str] = Field(None, example="Buy groceries and fruits")
    description: Optional[str] = Field(None, example="Milk, eggs, bread, apples")
    is_completed: Optional[bool] = Field(None, example=True)
    updated_by: Optional[UUIDType] = Field(None, example="123e4567-e89b-12d3-a456-426614174000")

    class Config:
        orm_mode = True


class ToDoResponseSchema(BaseModel):
    id: UUIDType = Field(..., example="123e4567-e89b-12d3-a456-426614174000")
    title: str = Field(..., example="Buy groceries")
    description: Optional[str] = Field(None, example="Milk, eggs, bread")
    is_completed: bool = Field(..., example=False)
    created_at: Optional[datetime] = Field(None, example="2025-05-23T10:00:00Z")
    updated_at: Optional[datetime] = Field(None, example="2025-05-23T11:00:00Z")
    created_by: Optional[UUIDType] = Field(None, example="123e4567-e89b-12d3-a456-426614174000")
    updated_by: Optional[UUIDType] = Field(None, example="123e4567-e89b-12d3-a456-426614174000")

    class Config:
        orm_mode = True
