class Calculator:
    def __init__(self):
        self.result = 0

    def add(self, a, b):
        try:
            self.result = a + b
            return self.result
        except TypeError:
            print("Error: Invalid input. Please enter numbers.")
            return None

    def subtract(self, a, b):
        try:
            self.result = a - b
            return self.result
        except TypeError:
            print("Error: Invalid input. Please enter numbers.")
            return None

    def multiply(self, a, b):
        try:
            self.result = a * b
            return self.result
        except TypeError:
            print("Error: Invalid input. Please enter numbers.")
            return None

    def divide(self, a, b):
        try:
            if b == 0:
                raise ZeroDivisionError("Cannot divide by zero.")
            self.result = a / b
            return self.result
        except ZeroDivisionError as zde:
            print(f"Error: {zde}")
            return None
        except TypeError:
            print("Error: Invalid input. Please enter numbers.")
            return None

    def power(self, a, b):
        try:
            self.result = a ** b
            return self.result
        except TypeError:
            print("Error: Invalid input. Please enter numbers.")
            return None

    def clear(self):
        self.result = 0

def get_number(prompt):
    while True:
        try:
            return float(input(prompt))
        except ValueError:
            print("Invalid input. Please enter a valid number.")

def main():
    calc = Calculator()
    operations = {
        '1': ('Add', calc.add),
        '2': ('Subtract', calc.subtract),
        '3': ('Multiply', calc.multiply),
        '4': ('Divide', calc.divide),
        '5': ('Power', calc.power),
        '6': ('Clear', calc.clear),
        '7': ('Exit', None)
    }

    while True:
        print("\n--- Calculator Menu ---")
        for key, (name, _) in operations.items():
            print(f"{key}. {name}")
        choice = input("Select operation: ")

        if choice == '7':
            print("Exiting calculator. Goodbye!")
            break
        elif choice == '6':
            calc.clear()
            print("Calculator cleared.")
            continue
        elif choice in operations and choice != '6':
            a = get_number("Enter first number: ")
            b = get_number("Enter second number: ")
            func = operations[choice][1]
            result = func(a, b)
            if result is not None:
                print(f"Result: {result}")
        else:
            print("Invalid choice. Please select a valid operation.")

if __name__ == "__main__":
    main()