from fastapi import FastAPI , Request , status
from app.database import Database
from app.routes import  (
    simple_model_routes,
    user_routes,
    todo_routes
)
from app.auth import AuthRoutes
import logging
from fastapi.exceptions import RequestValidationError
from app.global_constants import GlobalConstants
from app.auth_routes import auth_router



# Custom exception handler for validation errors
async def validation_exception_handler(request: Request, exc: RequestValidationError):
    errors = exc.errors()
    error_messages = []

    for error in errors:
        field = error.get("loc")[-1]  # Extract the field name
        msg = error.get("msg")  # Extract the error message
        error_messages.append(field)

    return GlobalConstants.return_api_response(
        message=f"{GlobalConstants.api_response_messages.missing_required_parameters}: {', '.join(error_messages)}",
        result=None,
        status_code=status.HTTP_400_BAD_REQUEST
    )


def create_app():
    app = FastAPI(title="FastAPI Application", version="1.0.0")
    
    # Register the custom exception handler for validation errors
    app.add_exception_handler(RequestValidationError, validation_exception_handler)

    # Create database tables
    print("Creating database tables...")
    logging.info("Creating database tables...")
    Database.Base.metadata.create_all(bind=Database.engine)
    logging.info("Database tables created.")
    print("Database tables created.")   

    # Include the user routes
    # app.include_router(AuthRoutes.router,tags=["Authentication"])
    # app.include_router(simple_model_routes.SimpleModelRoutes.router,tags=["Simple Model"])
    app.include_router(auth_router, tags=["Authentication"])
    app.include_router(user_routes.UserRoutes.router,tags=["User"])
    app.include_router(todo_routes.ToDoRoutes.router,tags=["ToDo"])



    return app
