from sqlalchemy import create_engine, exc
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy.orm import sessionmaker
from app.config import Config
import logging

class Database:
    # Base class for declarative class definitions (main database)
    Base = declarative_base()

    # Configure logging for this module
    logging.basicConfig(level=logging.INFO)
    logger = logging.getLogger(__name__)

    # Database configuration: get the connection string from config
    DATABASE_URL = Config.SQLALCHEMY_DATABASE_URI
    
    # Create SQLAlchemy engine with connection pool settings
    engine = create_engine(DATABASE_URL)

    # Create a configured "Session" class
    SessionLocal = sessionmaker(autocommit=False, autoflush=False, bind=engine)
    # Redefine Base for ORM models (main database)
    Base = declarative_base()

    # Create all tables in the database (with error handling)
    try:
        Base.metadata.create_all(bind=engine)
        logger.info("Database tables created successfully.")
    except exc.SQLAlchemyError as e:
        logger.error(f"Failed to create database tables: {e}")

# Dependency to get a database session (for use in FastAPI or similar frameworks)
def get_db():
    db = Database.SessionLocal()
    try:
        yield db  # Provide the session to the caller
    except exc.SQLAlchemyError as e:
        Database.logger.error(f"Database error occurred: {e}")
        db.rollback()  # Rollback in case of error
        raise  # Re-raise the exception for further handling
    finally:
        db.close()  # Always close the session

