import uuid
from sqlalchemy import Column, String, DateTime
from sqlalchemy.dialects.postgresql import UUID
from app.database import Database
from datetime import datetime, timezone
from pydantic import BaseModel, Field, EmailStr
from typing import Optional
from uuid import UUID as UUID_TYPE

# SQLAlchemy User Model
class User(Database.Base):
    __tablename__ = "users"

    id = Column(UUID(as_uuid=True), primary_key=True, default=uuid.uuid4, index=True)
    username = Column(String, unique=True, nullable=False)
    email = Column(String, unique=True, nullable=False)
    full_name = Column(String, nullable=True)
    hashed_password = Column(String, nullable=False)
    created_at = Column(DateTime, default=datetime.now(timezone.utc))
    updated_at = Column(DateTime, default=datetime.now(timezone.utc), onupdate=datetime.now(timezone.utc))
    created_by = Column(String, nullable=True)
    updated_by = Column(String, nullable=True)



class UserCreateSchema(BaseModel):
    username: str = Field(..., example="john_doe")
    email: EmailStr = Field(..., example="john@example.com")
    full_name: Optional[str] = Field(..., example="John Doe")
    password: str = Field(..., example="securepassword")
    created_by: Optional[str] = Field(..., example="admin")

    class Config:
        orm_mode = True


class UserUpdateSchema(BaseModel):
    user_id: UUID_TYPE = Field(..., example="8c5d62dc-7b87-4e5b-9d8f-8d54757c8a2e")
    email: Optional[EmailStr] = Field(None, example="john_updated@example.com")
    full_name: Optional[str] = Field(None, example="John Doe Updated")
    password: Optional[str] = Field(None, example="newsecurepassword")
    updated_by: Optional[str] = Field(..., example="admin")

    class Config:
        orm_mode = True


class UserResponseSchema(BaseModel):
    id: UUID_TYPE = Field(..., example="8c5d62dc-7b87-4e5b-9d8f-8d54757c8a2e")
    username: str = Field(..., example="john_doe")
    email: EmailStr = Field(..., example="john@example.com")
    full_name: Optional[str] = Field(None, example="John Doe")
    created_at: Optional[datetime] = Field(None, example="2021-08-01T00:00:00Z")
    updated_at: Optional[datetime] = Field(None, example="2021-08-02T00:00:00Z")
    created_by: Optional[str] = Field(None, example="admin")
    updated_by: Optional[str] = Field(None, example="admin")

    class Config:
        orm_mode = True
