class Student:
    def __init__(self, student_id, name, age, gender, grade, email):
        self.student_id = student_id
        self.name = name
        self.age = age
        self.gender = gender
        self.grade = grade
        self.email = email

    def display(self):
        print(f"ID: {self.student_id}, Name: {self.name}, Age: {self.age}, Gender: {self.gender}, Grade: {self.grade}, Email: {self.email}")

class StudentManager:
    def __init__(self):
        self.students = []

    def add_student(self):
        print("\n--- Add Student ---")
        student_id = input("Enter ID: ")
        name = input("Enter Name: ")
        age = input("Enter Age: ")
        gender = input("Enter Gender: ")
        grade = input("Enter Grade: ")
        email = input("Enter Email: ")

        student = Student(student_id, name, age, gender, grade, email)
        self.students.append(student)
        print("✅ Student added successfully!\n")

    def view_students(self):
        print("\n--- Student List ---")
        if not self.students:
            print("No students available.\n")
        else:
            for student in self.students:
                student.display()

    def update_student(self):
        print("\n--- Update Student ---")
        student_id = input("Enter ID of student to update: ")
        for student in self.students:
            if student.student_id == student_id:
                student.name = input("Enter new Name: ")
                student.age = input("Enter new Age: ")
                student.gender = input("Enter new Gender: ")
                student.grade = input("Enter new Grade: ")
                student.email = input("Enter new Email: ")
                print("✅ Student updated successfully!\n")
                return
        print("❌ Student not found.\n")

    def delete_student(self):
        print("\n--- Delete Student ---")
        student_id = input("Enter ID of student to delete: ")
        for student in self.students:
            if student.student_id == student_id:
                self.students.remove(student)
                print("✅ Student deleted successfully!\n")
                return
        print("❌ Student not found.\n")

def main():
    manager = StudentManager()

    while True:
        print("\n🎓 Student Management System")
        print("1. Add Student")
        print("2. View Students")
        print("3. Update Student")
        print("4. Delete Student")
        print("5. Exit")

        choice = input("Enter your choice (1-5): ")

        if choice == '1':
            manager.add_student()
        elif choice == '2':
            manager.view_students()
        elif choice == '3':
            manager.update_student()
        elif choice == '4':
            manager.delete_student()
        elif choice == '5':
            print("👋 Exiting. Goodbye!")
            break
        else:
            print("⚠️ Invalid choice. Please try again.")

if __name__ == "__main__":
    main()
