import argparse
import os
import json
import csv

def parse_txt(file_path):
    print("Parsing TXT file:")
    with open(file_path, 'r') as file:
        for line in file:
            print(line.strip())

def parse_json(file_path):
    print("Parsing JSON file:")
    with open(file_path, 'r') as file:
        data = json.load(file)
        print(json.dumps(data, indent=4))

def parse_csv(file_path):
    print("Parsing CSV file:")
    with open(file_path, 'r') as file:
        reader = csv.reader(file)
        for row in reader:
            print(row)

def main():
    parser = argparse.ArgumentParser(description="Simple File Parser CLI Tool")
    parser.add_argument("file", help="Path to the file to parse")
    args = parser.parse_args()

    file_path = args.file

    if not os.path.isfile(file_path):
        print("Error: File does not exist.")
        return

    ext = os.path.splitext(file_path)[1].lower()

    if ext == ".txt":
        parse_txt(file_path)
    elif ext == ".json":
        parse_json(file_path)
    elif ext == ".csv":
        parse_csv(file_path)
    else:
        print("Unsupported file type.")

if __name__ == "__main__":
    main()
