class Student:
    def __init__(self, student_id, name, age, grade):
        self.student_id = student_id
        self.name = name
        self.age = age
        self.grade = grade

    def display(self):
        print(f"ID: {self.student_id}, Name: {self.name}, Age: {self.age}, Grade: {self.grade}")

class StudentManager:
    def __init__(self):
        self.students = []

    def add_student(self, student):
        self.students.append(student)
        print("Student added successfully.")

    def remove_student(self, student_id):
        for s in self.students:
            if s.student_id == student_id:
                self.students.remove(s)
                print("Student removed.")
                return
        print("Student not found.")

    def view_students(self):
        if not self.students:
            print("No students found.")
            return
        print("\n--- Student List ---")
        for s in self.students:
            s.display()

    def search_student(self, student_id):
        for s in self.students:
            if s.student_id == student_id:
                print("Student found:")
                s.display()
                return
        print("Student not found.")

def menu():
    manager = StudentManager()

    while True:
        print("\n--- Student Management System ---")
        print("1. Add Student")
        print("2. Remove Student")
        print("3. View All Students")
        print("4. Search Student by ID")
        print("5. Exit")

        choice = input("Enter your choice: ")

        if choice == '1':
            sid = input("Enter Student ID: ")
            name = input("Enter Name: ")
            age = input("Enter Age: ")
            grade = input("Enter Grade: ")
            student = Student(sid, name, age, grade)
            manager.add_student(student)
        elif choice == '2':
            sid = input("Enter Student ID to remove: ")
            manager.remove_student(sid)
        elif choice == '3':
            manager.view_students()
        elif choice == '4':
            sid = input("Enter Student ID to search: ")
            manager.search_student(sid)
        elif choice == '5':
            print("Exiting...")
            break
        else:
            print("Invalid choice! Please select 1-5.")

if __name__ == "__main__":
    menu()
