import argparse

def parse_file(file_path):
    try:
        f = open(file_path, 'r')
        content = f.read()
        lines = content.splitlines()
        words = content.split()
        characters = len(content)
        return len(lines), len(words), characters
    except FileNotFoundError:
        print(f"Error: File '{file_path}' not found.")
        return None

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("filepath")
    args = parser.parse_args()

    result = parse_file(args.filepath)
    if result:
        lines, words, characters = result
        print(f"Lines: {lines}",end="\n\n")
        print(f"Words: {words}",end="\n\n")
        print(f"Characters: {characters}",end="\n\n")

if __name__ == "__main__":
    main()
