class Student:
    def __init__(self, roll_no, name, marks):
        self.roll_no = roll_no
        self.name = name
        self.marks = marks

    def display(self):
        print(f"Roll No: {self.roll_no}, Name: {self.name}, Marks: {self.marks}")


class StudentManagementSystem:
    def __init__(self):
        self.students = []

    def add_student(self):
        roll_no = input("Enter Roll No: ")
        name = input("Enter Name: ")
        marks = float(input("Enter Marks: "))
        student = Student(roll_no, name, marks)
        self.students.append(student)
        print("Student added successfully!")

    def display_students(self):
        if not self.students:
            print("No students to display.")
        else:
            print("\n--- Student List ---")
            for student in self.students:
                student.display()

    def search_student(self):
        roll_no = input("Enter Roll No to search: ")
        for student in self.students:
            if student.roll_no == roll_no:
                print("Student found:")
                student.display()
                return
        print("Student not found.")

    def delete_student(self):
        roll_no = input("Enter Roll No to delete: ")
        for student in self.students:
            if student.roll_no == roll_no:
                self.students.remove(student)
                print("Student deleted successfully!")
                return
        print("Student not found.")


def main():
    sms = StudentManagementSystem()

    while True:
        print("\n====== Student Management System ======")
        print("1. Add Student")
        print("2. Display Students")
        print("3. Search Student")
        print("4. Delete Student")
        print("5. Exit")

        choice = input("Enter your choice (1-5): ")

        if choice == "1":
            sms.add_student()
        elif choice == "2":
            sms.display_students()
        elif choice == "3":
            sms.search_student()
        elif choice == "4":
            sms.delete_student()
        elif choice == "5":
            print("Exiting... Goodbye!")
            break
        else:
            print("Invalid choice! Please select between 1-5.")


if __name__ == "__main__":
    main()
